/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.operands;

import emulator.assembler.SymbolTable;
import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.UnmappedMemoryException;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.operands.ByteOperand;
import emulator.support.IndirectYOperandEval;
import emulator.support.OperandEval;
import emulator.util.MemoryPtr;

public class IndirectY
extends ByteOperand {
    private HwWord abs_addr = new HwWord();
    private HwByte zp_addr;

    @Override
    public void init(Cpu6502 cpu) throws UnmappedMemoryException, BusWatchException {
        super.init(cpu);
        this.zp_addr = new HwByte((long)cpu.fetchProgramByte());
        this.abs_addr.setNumber(cpu.readWord((int)this.zp_addr.getNumber()));
        HwWord addr = new HwWord(this.abs_addr.getNumber());
        addr.add(cpu.getY());
        this.setAddress(addr);
    }

    @Override
    public int getByteCount() {
        return 1;
    }

    @Override
    public String getString() {
        return "($" + this.zp_addr + "),Y";
    }

    @Override
    public String getString(MemoryPtr mem_ref, SymbolTable symbols) {
        return "(" + symbols.getLabelOrAddress(mem_ref.getByteOp()) + "),Y";
    }

    @Override
    public int getExtraCycles() {
        if (!this.abs_addr.hi().equals(this.getAddress().hi())) {
            return 4;
        }
        return 3;
    }

    @Override
    public OperandEval getEvaluator(MemoryPtr mem_ref) {
        return new IndirectYOperandEval(mem_ref);
    }
}

